using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;

namespace gov.va.med.vbecs.DAL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/17/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Reagent type data access layer component.</summary>

		#endregion

	public class ReagentType
	{

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1005"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table containing reagent types.</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1278"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get combo box elements for reagent type.
		/// </summary>
		/// <returns>DataTable</returns>
		public static DataTable GetReagentTypes()
		{
			DataSet dataSet = Common.StoredProcedure.GetData(STOREDPROC.GetReagentTypes.StoredProcName);

			return dataSet.Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1279"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table containing AntigenType Tests</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1280"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get a list of antigen typing test IDs.
		/// </summary>
		/// <returns></returns>
		public static DataTable GetAntigenTypingTests()
		{
			DataSet dataSet = Common.StoredProcedure.GetData(STOREDPROC.GetAntigenTypingTests.StoredProcName);
			return dataSet.Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1281"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table containing AntigenTyping Reagent types.</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1282"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get a list of reagent types and its associated antigen typing test ID.
		/// </summary>
		/// <returns></returns>
		public static DataTable GetAntigenTypingReagentTypes()
		{
			DataSet dataSet = Common.StoredProcedure.GetData(STOREDPROC.GetAntigenTypingReagentTypes.StoredProcName);
			return dataSet.Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/23/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1283"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table containing reagent types for QC.</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1285"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get a list of reagent types used for QC during antigen typing.
		/// </summary>
		/// <returns></returns>
		public static DataTable GetAntigenTypingQCReagentTypes()
		{
			DataSet dataSet = Common.StoredProcedure.GetData(STOREDPROC.GetAntigenTypingQCReagentTypes.StoredProcName);
			return dataSet.Tables[0];
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1014"> 
		///		<ExpectedInput>Valid division code.</ExpectedInput>
		///		<ExpectedOutput>Data table of reagent minimum stock levels.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1957"> 
		///		<ExpectedInput>Invalid Division</ExpectedInput>
		///		<ExpectedOutput>Empty DataTabale</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Gets a data table of reagent minimum stock levels based on the division code.
		/// </summary>
		/// <param name="division">string</param>
		/// <returns>DataTable</returns>
		public static DataTable GetExistingMinimumLevels(string division)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExistingReagentTypes.divisioncode, System.Data.SqlDbType.VarChar)
								  };
		
			prms[0].Value = division;
		
			DataSet dataSet = Common.StoredProcedure.GetData(STOREDPROC.GetExistingReagentTypes.StoredProcName, prms);
			return dataSet.Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/3/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1083"> 
		///		<ExpectedInput>Valid division code.</ExpectedInput>
		///		<ExpectedOutput>Data table of reagent types to daily QC.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1958"> 
		///		<ExpectedInput>Invalid DivisionCode</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Gets a data table of reagent types to daily QC
		/// </summary>
		/// <param name="divisionCode">string</param>
		/// <returns>DataTable</returns>
		public static DataTable GetDailyQCReagentTypes(string divisionCode)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetDailyQCReagentTypes.divisioncode, System.Data.SqlDbType.VarChar)
				};
		
			prms[0].Value = divisionCode;
		
			DataSet dataSet = Common.StoredProcedure.GetData(STOREDPROC.GetDailyQCReagentTypes.StoredProcName, prms);
			return dataSet.Tables[0];
		}
		


		///<Developers>
		///	<Developer>Software Architectects Inc.</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8083"> 
		///		<ExpectedInput>Valid WorklistGUid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8084"> 
		///		<ExpectedInput>Invalid WorklistGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets a data table of reagent types to daily QC
		/// </summary>
		/// <param name="dailyQcWorklistGuid"></param>
		/// <returns></returns>
		public static DataTable GetDailyQCReagentTypesForPartiallyCompletedQc(Guid dailyQcWorklistGuid)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetDailyQCReagentTypesForPartiallyCompletedQc.dailyqcworklistguid, System.Data.SqlDbType.UniqueIdentifier)
				};
		
			prms[0].Value = dailyQcWorklistGuid;
		
			DataSet dataSet = Common.StoredProcedure.GetData(STOREDPROC.GetDailyQCReagentTypesForPartiallyCompletedQc.StoredProcName, prms);
			return dataSet.Tables[0];

		}
		

		///<Developers>
		///	<Developer>Software Architectects Inc.</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8085"> 
		///		<ExpectedInput>true</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8086"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// spInsertReagentTestParameter
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static DataTable GetEmptyReagentTestParameterTableSchema(bool isUpdate)
		{
			System.Data.DataTable dtEmpty = new DataTable(Common.VbecsTables.ReagentTestParameter.TableName);

			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.ReagentTestParameterGuid, typeof(System.Guid));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.ReagentTypeId, typeof(int));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.CommercialIndicator, typeof(bool));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.MustUseIndicator, typeof(bool));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.CanChangeIndicator, typeof(bool));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.DailyUseIndicator, typeof(bool));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.TestWithName, typeof(string));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.TestWithId, typeof(int));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.SetVialId, typeof(string));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.ReactivityPhaseCode, typeof(string));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.ExpectedMinimumReactions, typeof(string));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.DivisionCode, typeof(string));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.RecordStatusCode, typeof(string));
			dtEmpty.Columns.Add(TABLE.ReagentTestParameter.SortColumn, typeof(int));

			return(dtEmpty);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1353"> 
		///		<ExpectedInput>Division code, 0 commercial indicator</ExpectedInput>
		///		<ExpectedOutput>The datatable containing the list of daily reagent types for non-commercial</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1594"> 
		///		<ExpectedInput>Invalid Division</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the list of daily reagent types
		/// </summary>
		/// <param name="divisionCode">divisionCode</param>
		/// <param name="commercialIndicator">commercialIndicator</param>
		/// <returns>Data table</returns>
		public static DataTable GetReagentQCData(string divisionCode, bool commercialIndicator)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetReagentQC.DivisionCode, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetReagentQC.CommercialIndicator, System.Data.SqlDbType.Bit),
			};
			prms[0].Value = divisionCode;
			if(commercialIndicator)
			{
				prms[1].Value = 1;
			}
			else
			{
				prms[1].Value = 0;
			}
			System.Data.DataTable dtReagentQCData = StoredProcedure.GetData(STOREDPROC.GetReagentQC.StoredProcName, prms).Tables[0];

			return dtReagentQCData;
		}
	
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/29/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1545"> 
		///		<ExpectedInput>None expected</ExpectedInput>
		///		<ExpectedOutput>An array list of expected minimum reactions that a reagent type can ve set to.</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1286"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// returns an array list of expected minimum reactions that a reagent type can ve set to.
		/// </summary>
		/// <returns>ArrayList</returns>
		public static System.Collections.ArrayList GetCanChangeExpectedMinReactions()
		{
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetCanChangeExpectedMinReactions.StoredProcName);
			
			System.Collections.ArrayList al = new System.Collections.ArrayList();
			
			foreach(System.Data.DataRow dtRow in ds.Tables[0].Rows)
			{
				al.Add(dtRow[Common.VbecsTables.TestResult.TestResultText].ToString().Trim());
			}
			
			return al;
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1013"> 
		///		<ExpectedInput>Valid Reagent type ID, minimum stock level, division code, last update user, and row version.</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1961"> 
		///		<ExpectedInput>Invalid row version</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Updates the reagent type parameters.
		/// </summary>
		/// <param name="reagentTypeParameterGuid">Guid</param>
		/// <param name="minimumStockLevel">int</param>
		/// <param name="lastUpdateUser">string</param>
		/// <param name="rowVersion">byte[]</param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		public static void SaveReagentStockLevels(Guid reagentTypeParameterGuid, int minimumStockLevel, string lastUpdateUser, byte[] rowVersion, Common.UpdateFunction lastUpdateFunctionId)
		{ 
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.UpdateReagentTypeParameter.reagenttypeparameterguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.UpdateReagentTypeParameter.minimumstocklevel, System.Data.SqlDbType.Int),
					new SqlParameter(STOREDPROC.UpdateReagentTypeParameter.lastupdateuser, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.UpdateReagentTypeParameter.rowversion, System.Data.SqlDbType.Binary),
					new SqlParameter(STOREDPROC.UpdateReagentTypeParameter.lastupdatefunctionid, System.Data.SqlDbType.Int)
				};
		
			prms[0].Value = reagentTypeParameterGuid;
			prms[1].Value = minimumStockLevel;
			prms[2].Value = lastUpdateUser;
			prms[3].Value = rowVersion;
			prms[4].Value = (int)lastUpdateFunctionId;
		
			(new StoredProcedure()).TransactionalGetValue(STOREDPROC.UpdateReagentTypeParameter.StoredProcName, prms);
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2189"> 
		///		<ExpectedInput>Valid Reagent type ID, minimum stock level, division code, updatefunction</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2190"> 
		///		<ExpectedInput>Invalid TypeId</ExpectedInput>
		///		<ExpectedOutput>DAL.DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// InsertReagent
		/// </summary>
		/// <param name="reagentTypeId"></param>
		/// <param name="minimumStockLevel"></param>
		/// <param name="lastUpdateFunctionId"></param>
		public static void InsertReagent(int reagentTypeId, short minimumStockLevel, Common.UpdateFunction lastUpdateFunctionId)
		{
			SqlParameter[] prms = 
				{
					
					new SqlParameter(STOREDPROC.InsertReagentTypeParameter.reagenttypeid, System.Data.SqlDbType.Int),
					new SqlParameter(STOREDPROC.InsertReagentTypeParameter.minimumstocklevel, System.Data.SqlDbType.Int),
					new SqlParameter(STOREDPROC.InsertReagentTypeParameter.lastupdateuser, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.InsertReagentTypeParameter.lastupdatefunctionid, System.Data.SqlDbType.Int),
					new SqlParameter(STOREDPROC.InsertReagentTypeParameter.divisioncode, System.Data.SqlDbType.Char),
					new SqlParameter(STOREDPROC.InsertReagentTypeParameter.reagenttypeparameterguid, System.Data.SqlDbType.UniqueIdentifier)	
				};
		
			prms[0].Value = reagentTypeId;
			prms[1].Value = minimumStockLevel;
			prms[2].Value = Common.LogonUser.LogonUserName;
			prms[3].Value = (int)lastUpdateFunctionId;
			prms[4].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[5].Value = System.Guid.NewGuid();
		
			(new StoredProcedure()).TransactionalGetValue(STOREDPROC.InsertReagentTypeParameter.StoredProcName, prms);
		}
	}
}






